#---------------------------------------------------------------------------
# Copyright 2012 The Open Source Electronic Health Record Agent
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#---------------------------------------------------------------------------

from OSEHRAHelper import ConnectToMUMPS,PROMPT
from CreateSystemManager import SignInAsSysmtemManager

def gotoRegisterPatientMenu(VistA):
  SignInAsSysmtemManager(VistA)
  VistA.wait('Select Systems Manager Menu Option:')
  VistA.write('Register a Patient')

def gotoPrompt(VistA):
  VistA.wait('PATIENT NAME:')
  VistA.write('')
  VistA.wait('Select Systems Manager Menu Option:')
  VistA.write('')
  VistA.wait('//')
  VistA.write('')


def AddOnePatient(VistA, LastName, FirstName, Gender, DOB, SSN, Veteran, Percentage, isLastOne=False):
    OptionList = ['printer: ',
                  'PATIENT NAME']
    while True:
      index = VistA.multiwait(OptionList)
      if index == len(OptionList)-1:
        VistA.write(LastName+','+FirstName)
        break
      if index == 0:
        VistA.write("NULL DEVICE")

    VistA.wait('ARE YOU ADDING')
    VistA.write('Y')
    VistA.wait('SEX')
    VistA.write(Gender)
    VistA.wait('DATE OF BIRTH')
    VistA.write(DOB)
    VistA.wait('SOCIAL SECURITY NUMBER')
    VistA.write(SSN)
    VistA.wait('TYPE')
    if Veteran=='Y':
        VistA.write('SC VETERAN')
        VistA.wait('PATIENT VETERAN')
        VistA.write('YES')
        VistA.wait('SERVICE CONNECTED')
        VistA.write('YES')
    else:
        VistA.write('NON-VETERAN')
        VistA.wait('PATIENT VETERAN')
        VistA.write('NO')
        VistA.wait('SERVICE CONNECTED')
        VistA.write('NO')
    VistA.wait('MULTIPLE BIRTH INDICATOR')
    VistA.write('')
    index = VistA.multiwait(['FAMILY \(LAST\) NAME:','a new patient'])
    if index == 1:
        VistA.write('Y')
        VistA.wait('//')
        VistA.write('^\r')
    else:
        VistA.write('^\r')
    VistA.wait('MAIDEN NAME:')
    VistA.write('')
    VistA.wait('[CITY]')
    VistA.write('Santa Monica')
    VistA.wait('[STATE]')
    VistA.write('California')
    VistA.wait('ALIAS')
    VistA.write('')
    if VistA.type=='cache':
      # Enter in more information about the patient.
      VistA.wait('exit:')
      VistA.write('\r')
      VistA.wait('Patient Data')
      VistA.write('Y')
      VistA.wait('QUIT')
      VistA.write('4')
      VistA.wait('COUNTRY')
      VistA.write('')
      VistA.wait('STREET ADDRESS')
      VistA.write('834 Ocean Vista Avenue\r')
      VistA.wait('ZIP')
      VistA.write('90401')
      VistA.wait('CITY')
      VistA.write('1')
      VistA.wait('PHONE NUMBER')
      VistA.write('310-555-2233\r\r')
      VistA.wait('changes')
      VistA.write('Y\r')
      VistA.wait('QUIT')
      VistA.write('^2')
      VistA.wait('QUIT')
      VistA.write('3')
      VistA.wait('ETHNICITY')
      VistA.write('N')
      VistA.wait('RACE')
      VistA.write('B\rY\r')
      VistA.wait('QUIT')
      VistA.write('^3')
      VistA.wait('QUIT')
      VistA.write('1')
      VistA.wait('PRIMARY NOK')
      VistA.write('Carter,David J Sr')
      VistA.wait('RELATIONSHIP')
      VistA.write('FATHER')
      VistA.wait('ADDRESS')
      VistA.write('Y')
      VistA.wait('WORK PHONE')
      VistA.write('310-555-9876')
      VistA.wait('QUIT')
      VistA.write('^7')
      VistA.wait('QUIT')
      if Veteran=='Y':
        VistA.write('1')
        VistA.wait('TYPE')
        VistA.write('\r\r')
        VistA.wait('PERCENTAGE')
        VistA.write(Percentage)
        VistA.write('^')
        VistA.wait('QUIT')
      VistA.write('3')
      VistA.wait('PRIMARY ELIGIBILITY CODE:')
      if Veteran=='Y':
        VistA.write('\r\r\r\r')
      else:
        VistA.write('2\r\r\r\r')
      VistA.wait('QUIT')
      VistA.write('^')
      # this is the part that you will need to answer local questions
      VistA.wait('DO YOU WANT TO UPDATE THESE INCONSISTENCIES NOW\?')
      VistA.write('N')
      if Veteran == 'Y': 
        if Percentage == '25':
          VistA.wait('missing Income Data\?')
          VistA.write('N')
      VistA.wait('condition')
      VistA.write('N')
      VistA.wait('today')
      VistA.write('Y\r')
      VistA.wait('TYPE OF BENEFIT APPLIED FOR: ')
      VistA.write('3') # outpatient medical
      VistA.wait('TYPE OF CARE APPLIED FOR:')
      VistA.write('5') # all other
      VistA.wait('FACILITY APPLYING TO:')
      VistA.write('')
      VistA.wait('REGISTRATION ELIGIBILITY CODE:')
      VistA.write('')
      VistA.wait('NEED RELATED TO AN ACCIDENT:')
      VistA.write('U')
      VistA.wait('NEED RELATED TO OCCUPATION:')
      VistA.write('U')
      if Veteran == 'Y':
        VistA.wait('Enrollment System\?')
        VistA.write('N')
        VistA.wait('as soon as available\? :')
        VistA.write('N')
      VistA.wait('PRINT 10-10EZ\?')
      VistA.write('N')
      #VistA.wait('PRINT DRUG PROFILE\?')
      #VistA.write('N')
      #VistA.wait('PRINT HEALTH SUMMARY\?')
      #VistA.write('N')
      VistA.wait('ROUTING SLIP\?')
      VistA.write('N')
    else:
      # Workaround to reconnect in GT.M after the attempt
      # to connect to MPI (Master Patient Index) times out.
      logfilename="AddOnePatient-"+FirstName+","+LastName+".log"
      VistA=ConnectToMUMPS("C:/Users/contestant/OSEHRA/Dashboards/OSEHRA-Automated-Testing-build/Testing/Log/"+logfilename,"CACHE","VISTA")

    if not isLastOne:
	  gotoPrompt
      #SignInAsSysmtemManager(VistA)
      #gotoRegisterPatientMenu(VistA)

def AddOnePatientVISN0(VistA, LastName, FirstName, Gender, DOB, SSN, Veteran, isLastOne=False):
  OptionList = ['printer: ',
                'PATIENT NAME']
  while True:
    index = VistA.multiwait(OptionList)
    if index == len(OptionList)-1:
      VistA.write(LastName+','+FirstName)
      break
    if index == 0:
      VistA.write("NULL DEVICE")

  VistA.wait('ARE YOU ADDING')
  VistA.write('Y')
  VistA.wait('SEX')
  VistA.write(Gender)
  VistA.wait('DATE OF BIRTH')
  VistA.write(DOB)
  VistA.wait('SOCIAL SECURITY NUMBER')
  VistA.write(SSN)
  VistA.wait('TYPE')
  if Veteran=='Y':
      VistA.write('SC VETERAN')
      VistA.wait('PATIENT VETERAN')
      VistA.write('YES')
      VistA.wait('SERVICE CONNECTED')
      VistA.write('YES')
  else:
      VistA.write('NON-VETERAN')
      VistA.wait('PATIENT VETERAN')
      VistA.write('NO')
      VistA.wait('SERVICE CONNECTED')
      VistA.write('NO')
  VistA.wait('MULTIPLE BIRTH INDICATOR')
  VistA.write('')
  index = VistA.multiwait(['FAMILY \(LAST\) NAME:','a new patient'])
  if index == 1:
      VistA.write('Y')
      VistA.wait('//')
      VistA.write('^\r')
  else:
      VistA.write('^\r')
  VistA.wait('Press ENTER to continue')
  VistA.write('')
  VistA.wait('MAIDEN NAME:')
  VistA.write('')
  VistA.wait('[CITY]')
  VistA.write('Santa Monica')
  VistA.wait('[STATE]')
  VistA.write('California')
  VistA.wait('ALIAS')
  VistA.write('')
  # talk to MPI failed
  if VistA.type=='cache':
    # Enter in more information about the patient.
    VistA.wait('exit:')
    VistA.write('\r')
    VistA.wait('Do you wish to request a HINQ inquiry  \?')
    VistA.write('N')
    VistA.wait('Select Admitting Area:')
    VistA.write('')
    VistA.wait('Patient Data')
    VistA.write('Y')
    #VistA.wait('Address\?')
    #VistA.write('N')
    VistA.wait('QUIT')
    VistA.write('4')
    VistA.wait('COUNTRY')
    VistA.write('')
    VistA.wait('STREET ADDRESS')
    VistA.write('834 Ocean Vista Avenue\r')
    VistA.wait('ZIP')
    VistA.write('90401')
    VistA.wait('CITY')
    VistA.write('1')
    VistA.wait('PHONE NUMBER')
    VistA.write('310-555-2233\r\r')
    VistA.wait('changes')
    VistA.write('Y\r')
    VistA.wait('QUIT')
    VistA.write('^2')
    VistA.wait('QUIT')
    VistA.write('3')
    VistA.wait('ETHNICITY')
    VistA.write('N')
    VistA.wait('RACE')
    VistA.write('B\rY\r')
    VistA.wait('QUIT')
    VistA.write('^3')
    VistA.wait('QUIT')
    VistA.write('1')
    VistA.wait('PRIMARY NOK')
    VistA.write('Carter,David J Sr')
    VistA.wait('RELATIONSHIP')
    VistA.write('FATHER')
    VistA.wait('ADDRESS')
    VistA.write('Y')
    VistA.wait('WORK PHONE')
    VistA.write('310-555-9876')
    VistA.wait('QUIT')
    VistA.write('^7')
    VistA.wait('QUIT')
    VistA.write('3')
    VistA.wait('PRIMARY ELIGIBILITY CODE:')
    if Veteran=='Y':
      VistA.write('\r\r\r\r')
    else:
      VistA.write('2\r\r\r\r')
    VistA.wait('QUIT')
    VistA.write('^')
    # this is the part that you will need to answer local questions
    VistA.wait('NAME: ')
    VistA.write('^')
    VistA.wait('DO YOU WANT TO UPDATE THESE INCONSISTENCIES NOW\?')
    VistA.write('N')
    VistA.wait('missing Income Data\?')
    VistA.write('N')
    VistA.wait('condition')
    VistA.write('N')
    VistA.wait('today')
    VistA.write('Y\r')
    VistA.wait('TYPE OF BENEFIT APPLIED FOR: ')
    VistA.write('3') # outpatient medical
    VistA.wait('TYPE OF CARE APPLIED FOR:')
    VistA.write('5') # all other
    VistA.wait('FACILITY APPLYING TO:')
    VistA.write('')
    VistA.wait('REGISTRATION ELIGIBILITY CODE:')
    VistA.write('')
    VistA.wait('NEED RELATED TO AN ACCIDENT:')
    VistA.write('U')
    VistA.wait('NEED RELATED TO OCCUPATION:')
    VistA.write('U')
    if Veteran == 'Y':
      VistA.wait('Enrollment System\?')
      VistA.write('N')
      VistA.wait('as soon as available\? :')
      VistA.write('N')
    VistA.wait('PRINT 10-10EZ\?')
    VistA.write('N')
    VistA.wait('PRINT DRUG PROFILE\?')
    VistA.write('N')
    VistA.wait('PRINT HEALTH SUMMARY\?')
    VistA.write('N')
    VistA.wait('ROUTING SLIP\?')
    VistA.write('N')
    if isLastOne:
      gotoPrompt
